/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.jpa;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Class level annotation that indicates that a mapping inherited from a superclass should be "unmapped" in the child
 * class.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Target({TYPE})
@Retention(RUNTIME)
public @interface RemoveMapping {

    /**
     * (Required) The property name of the mapping to remove.
     *
     * @return the property name of the mapping to remove.
     */
    String name();

}
