/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.data.jpa.converters;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import java.math.BigInteger;

/**
 * Converts values of 0 or 1 to and from false or true.
 *
 * <p>The conversion treats the values as follows: 1 is true and 0 is false.</p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Converter
public class Boolean01Converter implements AttributeConverter<Boolean, BigInteger> {

    /**
     * {@inheritDoc}
     *
     * This implementation will convert from a false or true value to a 0 or 1 value.
     */
	@Override
	public BigInteger convertToDatabaseColumn(Boolean objectValue) {
		if (objectValue == null) {
			return BigInteger.valueOf(0);
		}
		return objectValue ? BigInteger.valueOf(1) : BigInteger.valueOf(0);
	}

    /**
     * {@inheritDoc}
     *
     * This implementation will convert from a false or true value to a 0 or 1 value.
     */
	@Override
	public Boolean convertToEntityAttribute(BigInteger dataValue) {
		if (dataValue == null) {
			return false;
		}
		return dataValue.intValue() == 1;
	}

}
