/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.kim;


import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.krad.kim.DocumentTypePermissionTypeServiceImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentTypeAndRelationshipToNoteAuthorPermissionTypeService
		extends DocumentTypePermissionTypeServiceImpl {

	@Override
	protected List<Permission> performPermissionMatches(
			Map<String, String> requestedDetails,
			List<Permission> permissionsList) {
				
		List<Permission> matchingPermissions = new ArrayList<Permission>();
		if (requestedDetails == null) {
			return matchingPermissions; // empty list
		}
		
		// loop over the permissions, checking the non-document-related ones
		for (Permission permission : permissionsList) {
            PermissionBo bo = PermissionBo.from(permission);
			if (Boolean.parseBoolean(requestedDetails
					.get(KimConstants.AttributeConstants.CREATED_BY_SELF))) {
				if(Boolean.parseBoolean(bo.getDetails().get(
						KimConstants.AttributeConstants.CREATED_BY_SELF_ONLY))){
					matchingPermissions.add(permission);
				}
				
			}else{
				if (!Boolean.parseBoolean(bo.getDetails().get(
						KimConstants.AttributeConstants.CREATED_BY_SELF_ONLY))) {
					matchingPermissions.add(permission);
				}
			}

		}
		
		matchingPermissions = super.performPermissionMatches(requestedDetails, matchingPermissions);
		return matchingPermissions;
	}
}
