/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.theme.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;

public class ThemeBuilderUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties retrieveThemeProperties(String themeDirectory) throws IOException {
        Properties themeProperties = null;
        try (FileInputStream fileInputStream = null;){
            File propertiesFile = new File(themeDirectory, "theme.properties");
            if (propertiesFile.exists()) {
                fileInputStream = new FileInputStream(propertiesFile);
                themeProperties = new Properties();
                themeProperties.load(fileInputStream);
            }
        }
        return themeProperties;
    }

    public static void storeThemeProperties(String themeDirectory, Properties themeProperties) throws IOException {
        File propertiesFile = new File(themeDirectory, "theme-derived.properties");
        if (propertiesFile.exists()) {
            FileUtils.forceDelete((File)propertiesFile);
        }
        try (FileWriter fileWriter = new FileWriter(propertiesFile);){
            themeProperties.store(fileWriter, null);
        }
    }

    public static List<String> getPropertyValueAsList(String key, Properties properties) {
        ArrayList propertyValueList = null;
        String[] propertyValueArray = ThemeBuilderUtils.getPropertyValueAsArray(key, properties);
        if (propertyValueArray != null) {
            propertyValueList = new ArrayList();
            Collections.addAll(propertyValueList, propertyValueArray);
        }
        return propertyValueList;
    }

    public static String[] getPropertyValueAsArray(String key, Properties properties) {
        String propertyValueString;
        String[] propertyValue = null;
        if (properties.containsKey(key) && !StringUtils.isBlank((String)(propertyValueString = properties.getProperty(key)))) {
            propertyValue = propertyValueString.split(",");
        }
        return propertyValue;
    }

    public static void copyProperty(String propertyKey, Properties sourceProperties, Properties targetProperties) {
        if (targetProperties != null && targetProperties.containsKey(propertyKey) && StringUtils.isNotBlank((String)targetProperties.getProperty(propertyKey))) {
            return;
        }
        if (sourceProperties != null && sourceProperties.containsKey(propertyKey)) {
            String propertyValue = sourceProperties.getProperty(propertyKey);
            if (targetProperties == null) {
                targetProperties = new Properties();
            }
            targetProperties.put(propertyKey, propertyValue);
        }
    }

    public static void validateFileExistence(List<File> filesToValidate, String exceptionMessage) {
        if (filesToValidate == null) {
            return;
        }
        for (File file : filesToValidate) {
            if (file.exists()) continue;
            throw new RuntimeException(exceptionMessage + " Path: " + file.getPath());
        }
    }

    public static List<File> getDirectoryFiles(File baseDirectory, String[] includes, String[] excludes) {
        ArrayList<File> directoryFiles = new ArrayList<File>();
        List<String> directoryFileNames = ThemeBuilderUtils.getDirectoryFileNames(baseDirectory, includes, excludes);
        for (String fileName : directoryFileNames) {
            directoryFiles.add(new File(baseDirectory, fileName));
        }
        return directoryFiles;
    }

    public static List<String> getDirectoryFileNames(File baseDirectory, String[] includes, String[] excludes) {
        ArrayList<String> files = new ArrayList<String>();
        DirectoryScanner scanner = new DirectoryScanner();
        if (includes != null) {
            scanner.setIncludes(includes);
        }
        if (excludes != null) {
            scanner.setExcludes(excludes);
        }
        scanner.setCaseSensitive(false);
        scanner.addDefaultExcludes();
        scanner.setBasedir(baseDirectory);
        scanner.scan();
        Collections.addAll(files, scanner.getIncludedFiles());
        return files;
    }

    public static List<File> getSubDirectories(File baseDirectory, List<String> subDirectoryNames) {
        ArrayList<File> subDirs = null;
        if (subDirectoryNames != null) {
            subDirs = new ArrayList<File>();
            for (String pluginName : subDirectoryNames) {
                subDirs.add(new File(baseDirectory, pluginName));
            }
        }
        return subDirs;
    }

    public static List<String> getDirectoryContents(File baseDirectory, String[] includes, String[] excludes) {
        ArrayList<String> contents = new ArrayList<String>();
        DirectoryScanner scanner = new DirectoryScanner();
        if (includes != null) {
            scanner.setIncludes(includes);
        }
        if (excludes != null) {
            scanner.setExcludes(excludes);
        }
        scanner.setCaseSensitive(false);
        scanner.addDefaultExcludes();
        scanner.setBasedir(baseDirectory);
        scanner.scan();
        Collections.addAll(contents, scanner.getIncludedDirectories());
        Collections.addAll(contents, scanner.getIncludedFiles());
        return contents;
    }

    public static void copyDirectory(String sourceDirectoryPath, String targetDirectoryPath) throws IOException {
        File sourceDir = new File(sourceDirectoryPath);
        if (!sourceDir.exists()) {
            return;
        }
        File targetDir = new File(targetDirectoryPath);
        if (targetDir.exists()) {
            FileUtils.forceDelete((File)targetDir);
        }
        targetDir.mkdir();
        FileUtils.copyDirectoryStructure((File)sourceDir, (File)targetDir);
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(targetDir);
        scanner.scan();
        for (String includedDirectory : scanner.getIncludedDirectories()) {
            File subdirectory = new File(targetDir, includedDirectory);
            if (!subdirectory.exists() || !subdirectory.isDirectory() || !subdirectory.getName().startsWith(".")) continue;
            FileUtils.forceDelete((File)subdirectory);
        }
    }

    public static void copyMissingContent(File sourceDirectory, File targetDirectory, List<String> sourceExcludes) throws IOException {
        String[] copyExcludes = null;
        if (sourceExcludes != null && !sourceExcludes.isEmpty()) {
            copyExcludes = new String[sourceExcludes.size()];
            copyExcludes = sourceExcludes.toArray(copyExcludes);
        }
        List<String> sourceDirectoryContents = ThemeBuilderUtils.getDirectoryContents(sourceDirectory, null, copyExcludes);
        List<String> targetDirectoryContents = ThemeBuilderUtils.getDirectoryContents(targetDirectory, null, null);
        for (String sourceContent : sourceDirectoryContents) {
            if (targetDirectoryContents.contains(sourceContent)) continue;
            File sourceFile = new File(sourceDirectory, sourceContent);
            File targetFile = new File(targetDirectory, sourceContent);
            if (sourceFile.isDirectory()) {
                targetFile.mkdir();
                continue;
            }
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
    }

    public static boolean inIncludeList(String name, String[] includes) {
        if (includes == null || includes.length == 0) {
            return true;
        }
        for (String include : includes) {
            if (!SelectorUtils.matchPath((String)include, (String)name, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean inExcludeList(String name, String[] excludes) {
        if (excludes == null || excludes.length == 0) {
            return false;
        }
        for (String exclude : excludes) {
            if (!SelectorUtils.matchPath((String)exclude, (String)name, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static void addExtensionToPatterns(String[] patterns, String extension) {
        if (patterns == null) {
            return;
        }
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i];
            if (pattern.endsWith("*") || pattern.endsWith(extension)) continue;
            patterns[i] = pattern + extension;
        }
    }

    public static List<String> getRelativePaths(File parentDirectory, List<File> files) {
        ArrayList<String> relativePaths = new ArrayList<String>();
        for (File file : files) {
            relativePaths.add(ThemeBuilderUtils.getRelativePath(parentDirectory, file));
        }
        return relativePaths;
    }

    public static String getRelativePath(File parentDirectory, File file) {
        String relativePath = null;
        String parentPath = parentDirectory.getPath();
        String childPath = file.getPath();
        if (childPath.startsWith(parentPath + File.separator)) {
            relativePath = childPath.substring(parentPath.length() + 1);
        }
        relativePath = relativePath.replaceAll("\\\\", "/");
        return relativePath;
    }

    public static String calculatePathToFile(File fromFile, File toFile) {
        StringBuilder pathToFile = new StringBuilder();
        int directoriesUp = 0;
        String parentPath = fromFile.getParent();
        while (parentPath != null && !ThemeBuilderUtils.fileMatchesPath(parentPath, toFile)) {
            File parent = new File(parentPath);
            parentPath = parent.getParent();
            ++directoriesUp;
        }
        if (parentPath != null) {
            pathToFile.append("../".repeat(Math.max(0, directoriesUp)));
            String remainingPath = toFile.getPath().replace(parentPath, "");
            if (remainingPath.startsWith(File.separator)) {
                remainingPath = remainingPath.substring(1);
            }
            if ((remainingPath = remainingPath.replaceAll("\\\\", "/")).contains("/")) {
                int separatorIndex = remainingPath.lastIndexOf("/");
                remainingPath = remainingPath.substring(0, separatorIndex + 1);
            } else {
                remainingPath = null;
            }
            if (remainingPath != null) {
                pathToFile.append(remainingPath);
            }
        }
        return pathToFile.toString();
    }

    protected static boolean fileMatchesPath(String path, File file) {
        return file.getPath().startsWith(path);
    }

    public static List<File> orderFiles(List<File> pluginFiles, List<File> subDirFiles, List<String> loadFirstPatterns, List<String> loadLastPatterns, List<String> pluginLoadOrder, List<String> subDirLoadOrder) {
        List<File> matchedFiles;
        ArrayList<File> orderedFiles = new ArrayList<File>();
        ArrayList<File> allThemeFiles = new ArrayList<File>();
        if (pluginFiles != null) {
            allThemeFiles.addAll(pluginFiles);
        }
        if (subDirFiles != null) {
            allThemeFiles.addAll(subDirFiles);
        }
        ArrayList<File> endFiles = new ArrayList<File>();
        if (loadLastPatterns != null) {
            for (String pattern : loadLastPatterns) {
                endFiles.addAll(ThemeBuilderUtils.matchFiles(allThemeFiles, pattern));
            }
        }
        if (loadFirstPatterns != null) {
            for (String pattern : loadFirstPatterns) {
                matchedFiles = ThemeBuilderUtils.matchFiles(allThemeFiles, pattern);
                matchedFiles.removeAll(endFiles);
                orderedFiles.addAll(matchedFiles);
            }
        }
        if (pluginLoadOrder != null) {
            for (String pattern : pluginLoadOrder) {
                matchedFiles = ThemeBuilderUtils.matchFiles(pluginFiles, pattern);
                matchedFiles.removeAll(endFiles);
                matchedFiles.removeAll(orderedFiles);
                orderedFiles.addAll(matchedFiles);
            }
        }
        if (pluginFiles != null) {
            for (File pluginFile : pluginFiles) {
                if (orderedFiles.contains(pluginFile) || endFiles.contains(pluginFile)) continue;
                orderedFiles.add(pluginFile);
            }
        }
        if (subDirLoadOrder != null) {
            for (String pattern : subDirLoadOrder) {
                matchedFiles = ThemeBuilderUtils.matchFiles(subDirFiles, pattern);
                matchedFiles.removeAll(endFiles);
                matchedFiles.removeAll(orderedFiles);
                orderedFiles.addAll(matchedFiles);
            }
        }
        if (subDirFiles != null) {
            for (File subDirFile : subDirFiles) {
                if (orderedFiles.contains(subDirFile) || endFiles.contains(subDirFile)) continue;
                orderedFiles.add(subDirFile);
            }
        }
        File[] endFileArray = new File[endFiles.size()];
        endFileArray = endFiles.toArray(endFileArray);
        for (int i = endFileArray.length - 1; i >= 0; --i) {
            orderedFiles.add(endFileArray[i]);
        }
        return orderedFiles;
    }

    public static List<File> matchFiles(List<File> filesToMatch, String pattern) {
        ArrayList<File> matchedFiles = new ArrayList<File>();
        for (File file : filesToMatch) {
            if (!ThemeBuilderUtils.isMatch(file, pattern)) continue;
            matchedFiles.add(file);
        }
        return matchedFiles;
    }

    public static boolean isMatch(File file, String pattern) {
        boolean isMatch = false;
        String fileBasename = FileUtils.basename((String)file.getName());
        if (fileBasename.endsWith(".")) {
            fileBasename = fileBasename.substring(0, fileBasename.length() - 1);
        }
        if (SelectorUtils.matchPath((String)pattern, (String)fileBasename, (boolean)false)) {
            isMatch = true;
        }
        return isMatch;
    }

    public static String[] addToArray(String[] array, String stringToAdd) {
        String[] arrayToAdd = null;
        if (stringToAdd != null) {
            arrayToAdd = new String[]{stringToAdd};
        }
        return ThemeBuilderUtils.addToArray(array, arrayToAdd);
    }

    public static String[] addToArray(String[] array, String[] arrayToAdd) {
        if (array == null) {
            return arrayToAdd;
        }
        if (arrayToAdd == null) {
            return array;
        }
        int combinedArrayLength = array.length + arrayToAdd.length;
        String[] combinedArray = new String[combinedArrayLength];
        System.arraycopy(array, 0, combinedArray, 0, array.length);
        System.arraycopy(arrayToAdd, 0, combinedArray, array.length, arrayToAdd.length);
        return combinedArray;
    }
}

