/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.impl;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.rice.krad.datadictionary.BeanOverride;
import org.kuali.rice.krad.datadictionary.FieldOverride;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * The base implementation of the BeanOverride interface.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class BeanOverrideImpl implements BeanOverride {
    private String beanName;
    private List<FieldOverride> fieldOverrides;

    /**
     * @see org.kuali.rice.krad.datadictionary.BeanOverride#getFieldOverrides()
     */
    @Override
    public List<FieldOverride> getFieldOverrides() {
        return this.fieldOverrides;
    }

    public void setFieldOverrides(List<FieldOverride> fieldOverirdes) {
        this.fieldOverrides = fieldOverirdes;
    }

    /**
     * @see org.kuali.rice.krad.datadictionary.BeanOverride#getBeanName()
     */
    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    /**
     * @see org.kuali.rice.krad.datadictionary.BeanOverride#performOverride(java.lang.Object)
     */
    @Override
    public void performOverride(Object bean) {
        try {
            for (FieldOverride fieldOverride : fieldOverrides) {
                Object property = PropertyUtils.getProperty(bean, fieldOverride.getPropertyName());
                Object newProperty = fieldOverride.performFieldOverride(bean, property);
                BeanUtils.setProperty(bean, fieldOverride.getPropertyName(), newProperty);
            }
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);

        } catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}
