/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.UifConstants;

/**
 * Pattern for matching numeric characters, difference between NumericPatternConstraint and IntegerPatternConstraint
 * is that a numeric pattern constraint is for matching numeric characters and can be mixed with other characters
 * by setting allow flags on, while integer is for only positive/negative numbers
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTags({@BeanTag(name = "numericPatternConstraint", parent = "NumericPatternConstraint"),
        @BeanTag(name = "numericWithOperators", parent = "NumericWithOperators")})
public class NumericPatternConstraint extends AllowCharacterConstraint {

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getRegexString() {
        StringBuilder regexString = new StringBuilder("[0-9");
        regexString.append(this.getAllowedCharacterRegex());
        regexString.append("]");

        return regexString.toString();
    }

    /**
     * @see org.kuali.rice.krad.datadictionary.validation.constraint.BaseConstraint#getMessageKey()
     */
    @Override
    public String getMessageKey() {
        String messageKey = super.getMessageKey();
        if (StringUtils.isNotEmpty(messageKey)) {
            return messageKey;
        }

        return UifConstants.Messages.VALIDATION_MSG_KEY_PREFIX + "numericPattern";
    }

}
