/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

import java.util.ArrayList;
import java.util.List;

/**
 * Prerequisite constraints require that some other attribute be non-empty in order for the constraint to be valid.
 * So, a 7-digit US phone number might have a prerequisite of an area code, or an address street2 might have a
 * prerequisite that street1 is non-empty.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @since 1.1
 */
@BeanTag(name = "prerequisiteConstraint", parent = "PrerequisiteConstraint")
public class PrerequisiteConstraint extends BaseConstraint {
    protected String propertyName;

    @BeanTagAttribute(name = "propertyName")
    public String getPropertyName() {
        return propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    /**
     * @see BaseConstraint#getValidationMessageParams()
     * @return the validation message list if defined. If not defined,  return  the property name
     */
    public List<String> getValidationMessageParams() {
        if (super.getValidationMessageParams() == null) {
            ArrayList<String> params = new ArrayList<String>(1);
            params.add(getPropertyName());
            return params;
        } else {
            return super.getValidationMessageParams();
        }
    }
}
