/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.maintenance;

import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.DocumentAuthorizer;

/**
 * Authorizer class for {@link MaintenanceDocument} instances
 *
 * <p>
 * The <code>MaintenanceDocumentAuthorizer</code> extends the available actions of <code>DocumentAuthorizer</code>
 * for <code>MaintenanceDocument</code>s.
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @see org.kuali.rice.krad.document.DocumentAuthorizer
 */
public interface MaintenanceDocumentAuthorizer extends DocumentAuthorizer {

    /**
     * Determines whether the user has the permission to create a new <code>MaintenanceDocument</code>
     *
     * @param boClass <code>Class</code> of the <code>MaintenanceDocument</code>
     * @param user <code>Person</code> instance of the current user
     * @return <code>true</code> if the user is allowed to create a new <code>MaintenanceDocument</code> for
     *         the boClass, <code>false</code> otherwise
     */
    public boolean canCreate(Class boClass, Person user);

    /**
     * Determines whether the user has the permission to maintain a <code>MaintenanceDocument</code>
     *
     * @param dataObject <code>Object</code> of the <code>MaintenanceDocument</code>
     * @param user <code>Person</code> instance of the current user
     * @return <code>true</code> if the user is allowed to maintain the dataObject, <code>false</code> otherwise
     */
    public boolean canMaintain(Object dataObject, Person user);

    /**
     * Determines whether the user has the permission to create or maintain a <code>MaintenanceDocument</code>
     *
     * @param maintenanceDocument the <code>MaintenanceDocument</code>
     * @param user <code>Person</code> instance of the current user
     * @return <code>true</code> if the user is allowed to create or maintain the <code>MaintenanceDocument</code>,
     *         <code>false</code> otherwise
     */
    public boolean canCreateOrMaintain(MaintenanceDocument maintenanceDocument, Person user);

}
