/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.rules.rule;

import org.kuali.rice.krad.rules.rule.event.AddCollectionLineEvent;

/**
 * Defines a rule which gets invoked immediately before an object is added to a collection.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface AddCollectionLineRule extends BusinessRule {

    /**
     * Run the rules associated with adding an object to a collection.
     *
     * @param addEvent the event containing all of the object necessary to run the rules
     *
     * @return true if validation succeeds, false otherwise
     */
    boolean processAddCollectionLine(AddCollectionLineEvent addEvent);
}
