/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import org.kuali.rice.krad.document.Document;

/**
 * Implementations of this interface are able to serialize documents into XML that's used by the workflow engine to perform routing, searches,
 * etc.
 *
 */
public interface DocumentSerializerService extends SerializerService  {
    /**
     * Serializes a document into XML for the workflow engine
     *
     * @param document the document
     * @return a XML representation of the document
     */
    public String serializeDocumentToXmlForRouting(Document document);

}
