/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

/**
 * Indicates <code>Control</code> types that have a size property
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface SizedControl {

    /**
     * Retrieves the configured size for the control, which reflects the display width in characters for
     * the control within the UI
     *
     * @return int control size
     */
    public int getSize();

    /**
     * Sets the size for the control
     *
     * @param size
     */
    public void setSize(int size);
}
