/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.element;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;

/**
 * Content element that renders a non-breaking space HTML <code>&amp;nbsp;</code> tag
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "space", parent = "Uif-Space")
public class Space extends ContentElementBase {
    private static final long serialVersionUID = 4655642965438419569L;

    public Space() {
        super();
    }

    /**
     * Indicates that this element renders itself and does not use a template
     *
     * <p>
     * Since this method returns true, the renderOutput property provides
     * the HTML string representing this element.
     * </p>
     *
     * @return true - this object renders itself
     * {@inheritDoc}
     */
    @Override
    public boolean isSelfRendered() {
        return true;
    }

    /**
     * Provides the HTML string to be used to render a non-breaking space
     *
     * <p>The HTML for a Space element is <code>&amp;nbsp;</code></p>
     *
     * @return the HTML string for a non-breaking space
     * {@inheritDoc}
     */
    @Override
    public String getRenderedHtmlOutput() {
        return "&nbsp;";
    }
}
