/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.modifier;

import java.util.ArrayList;
import java.util.List;

import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.component.Component;

/**
 * Base class for <code>ComponentModifier</code> implementations
 *
 * <p>
 * Holds run phase property and defaults to the INITIALIZE phase, and the order
 * property for setting the order in which the component modifier will be
 * invoked
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public abstract class ComponentModifierBase extends UifDictionaryBeanBase implements ComponentModifier {
    private static final long serialVersionUID = -8284332412469942130L;

    private String runPhase;
    private String runCondition;
    private int order;

    public ComponentModifierBase() {
        super();

        runPhase = UifConstants.ViewPhases.INITIALIZE;
        order = 0;
    }

    /**
     * Default performInitialization impl (does nothing)
     *
     * {@inheritDoc}
     */
    @Override
    public void performInitialization(Object model, Component component) {

    }

    /**
     * @see org.kuali.rice.krad.uif.modifier.ComponentModifierBase#getComponentPrototypes()
     */
    @Override
    public List<Component> getComponentPrototypes() {
        List<Component> components = new ArrayList<Component>();

        return components;
    }

    /**
     * @see org.kuali.rice.krad.uif.modifier.ComponentModifier#getRunPhase()
     */
    @Override
    @BeanTagAttribute
    public String getRunPhase() {
        return this.runPhase;
    }

    /**
     * Setter for the component initializer run phase
     *
     * @param runPhase
     */
    public void setRunPhase(String runPhase) {
        this.runPhase = runPhase;
    }

    /**
     * @see org.kuali.rice.krad.uif.modifier.ComponentModifier#getRunCondition()
     */
    @Override
    @BeanTagAttribute
    public String getRunCondition() {
        return this.runCondition;
    }

    /**
     * Setter for the component modifiers run condition
     *
     * @param runCondition
     */
    public void setRunCondition(String runCondition) {
        this.runCondition = runCondition;
    }

    /**
     * @see org.springframework.core.Ordered#getOrder()
     */
    @Override
    @BeanTagAttribute
    public int getOrder() {
        return this.order;
    }

    /**
     * @see org.kuali.rice.krad.uif.component.Ordered#setOrder(int)
     */
    @Override
    public void setOrder(int order) {
        this.order = order;
    }

}
