/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.widget;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

import java.util.HashMap;
import java.util.Map;

/**
 * Growls sets up settings for growls global to the current view and its pages
 *
 * <p>
 * Some basic options of the plugin are exposed through this class, however additional options
 * can be passed through setComponentOptions as usual. However, the header and theme option is set
 * by the growl processing in PageGroup automatically. See the jquery jGrowl plugin for more details.
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "growls", parent = "Uif-Growls")
public class Growls extends WidgetBase {
    private static final long serialVersionUID = -8701090110933484411L;

    private boolean sticky;
    private int timeShown;
    private String position;

    public Growls() {
        super();
    }

    /**
     * Override to add property values to the template options
     *
     * {@inheritDoc}
     */
    @Override
    public Map<String, String> getTemplateOptions() {
        Map<String, String> templateOptions = super.getTemplateOptions();

        if (templateOptions == null) {
            super.setTemplateOptions(templateOptions = new HashMap<String, String>());
        }

        if (!templateOptions.containsKey("sticky")) {
            templateOptions.put("sticky", Boolean.toString(sticky));
        }
        if (!templateOptions.containsKey("life")) {
            templateOptions.put("life", Integer.toString(timeShown));
        }
        if (StringUtils.isNotBlank(position) && !templateOptions.containsKey("position")) {
            templateOptions.put("position", position);
        }

        return templateOptions;
    }

    /**
     * If true, the growl will stick to the page until the user dismisses it
     *
     * @return the sticky
     */
    @BeanTagAttribute
    public boolean isSticky() {
        return this.sticky;
    }

    /**
     * @param sticky the sticky to set
     */
    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    /**
     * The time growls are shown in milliseconds
     *
     * @return the timeShown
     */
    @BeanTagAttribute
    public int getTimeShown() {
        return this.timeShown;
    }

    /**
     * @param timeShown the timeShown to set
     */
    public void setTimeShown(int timeShown) {
        this.timeShown = timeShown;
    }

    /**
     * The position for the growls to appear in the window
     * There are five options available: top-left, top-right, bottom-left, bottom-right, center.
     *
     * @return the position
     */
    @BeanTagAttribute
    public String getPosition() {
        return this.position;
    }

    /**
     * @param position the position to set
     */
    public void setPosition(String position) {
        this.position = position;
    }
}
