/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.widget;

/**
 * Interface for components that support help.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface Helpable {

    /**
     * Help configuration object for the container
     *
     * <p>
     * External help information can be configured for the container. The
     * {@code Help} object can the configuration for rendering a link to
     * that help information.
     * </p>
     *
     * @return Help for container
     */
    Help getHelp();

    /**
     * Setter for the containers help content
     *
     * @param help
     */
    void setHelp(Help help);

    /**
     * Setter for the component's tooltip.
     *
     * <p>
     * This is used by the helper to set the help content to the tooltip.
     * </p>
     *
     *  @param tooltip Tooltip with the help for the container
     */
    void setTooltipOfComponent(Tooltip tooltip);

    /**
     * Help title which is used for the HTML title attribute of the help icon
     *
     * @return Help title for the container
     */
     String getHelpTitle();

}
