/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.util.documentserializer;

/**
 * This class represents metadata about the serializibility of a property during the document serialization proces..
 */
public interface PropertySerializabilityMetadata {
    /**
     * See docs for the elements of this enum
     */
    public enum PropertySerializability {
        /**
         * Indicates that the property represented by this metadata object should be serialized (i.e. have an open
         * and close XML tag rendered) as well as all of the property's primitives.  It does not mean that all child
         * non-primitive properties should be serialized.  Child non-primitives are only serialized if a call to
         * {@link PropertySerializabilityMetadata#getSerializableChildProperty(String)} returns a non-null result when
         * the child property name is passed in.
         */
        SERIALIZE_OBJECT_AND_ALL_PRIMITIVES,

        /**
         * Indicates that the property represented by this metadata object should be serialized (i.e. have an open
         * and close XML tag rendered).  Child properties (primitive or otherwise) are only serialized if a call to
         * {@link PropertySerializabilityMetadata#getSerializableChildProperty(String)} returns a non-null result when
         * the child property name is passed in.
         */
        SERIALIZE_OBJECT
    }

    /**
     * Returns the serializability of this property.  See {@link PropertySerializability}.
     *
     * @return
     */
    public PropertySerializability getPropertySerializability();

    /**
     * Returns the full path string of the property corresponding to this metadata.
     *
     * @return
     */
    public String getPathString();

    /**
     * Returns metadata bout a child property, if it exists
     *
     * @param childPropertyName the name of a child property, relative to this property (i.e. no .'s in the name)
     * @return null if there is no child property with the specified name, otherwise, metadata about the child
     */
    public PropertySerializabilityMetadata getSerializableChildProperty(String childPropertyName);
}
