/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.web.form;

import org.kuali.rice.krad.data.util.Link;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.uif.UifConstants.ViewType;
import org.kuali.rice.krad.web.bind.ChangeTracking;
import org.kuali.rice.krad.web.bind.RequestAccessible;

/**
 * Form class for <code>MaintenanceDocumentView</code> screens
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@ChangeTracking
@Link(path = "document.newMaintainableObject.dataObject")
public class MaintenanceDocumentForm extends DocumentFormBase {
	private static final long serialVersionUID = -5805825500852498048L;

    @RequestAccessible
	protected String dataObjectClassName;

    @RequestAccessible
	protected String maintenanceAction;

	public MaintenanceDocumentForm() {
		super();
		setViewTypeName(ViewType.MAINTENANCE);
	}

	@Override
	public MaintenanceDocument getDocument() {
		return (MaintenanceDocument) super.getDocument();
	}

	// This is to provide a setter with matching type to
	// public MaintenanceDocument getDocument() so that no
	// issues occur with spring 3.1-M2 bean wrappers
	public void setDocument(MaintenanceDocument document) {
	    super.setDocument(document);
	}

	public String getDataObjectClassName() {
		return this.dataObjectClassName;
	}

	public void setDataObjectClassName(String dataObjectClassName) {
		this.dataObjectClassName = dataObjectClassName;
	}

	public String getMaintenanceAction() {
		return this.maintenanceAction;
	}

	public void setMaintenanceAction(String maintenanceAction) {
		this.maintenanceAction = maintenanceAction;
	}

}
