/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryBeanBase;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.container.PageGroup;
import org.kuali.rice.krad.uif.element.BreadcrumbItem;
import org.kuali.rice.krad.uif.element.Header;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.util.UrlInfo;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;

@BeanTag(name="parentLocation", parent="Uif-ParentLocation")
public class ParentLocation
extends UifDictionaryBeanBase
implements Serializable {
    private static final long serialVersionUID = -6242148809697931126L;
    private UrlInfo parentViewUrl;
    private UrlInfo parentPageUrl;
    private String parentViewLabel;
    private String parentPageLabel;
    private BreadcrumbItem viewBreadcrumbItem;
    private BreadcrumbItem pageBreadcrumbItem;
    protected List<BreadcrumbItem> resolvedBreadcrumbItems = new ArrayList<BreadcrumbItem>();

    public List<BreadcrumbItem> constructParentLocationBreadcrumbItems(View view, Object currentModel, Map<String, Object> currentContext) {
        if (this.viewBreadcrumbItem == null) {
            return this.resolvedBreadcrumbItems;
        }
        this.handleExpressions(view, currentModel, currentContext, ViewLifecycle.getExpressionEvaluator());
        if (StringUtils.isNotBlank((String)this.parentViewUrl.getOriginalHref()) || StringUtils.isNotBlank((String)this.parentViewUrl.getViewId()) && StringUtils.isNotBlank((String)this.parentViewUrl.getControllerMapping())) {
            this.viewBreadcrumbItem.setUrl(this.parentViewUrl);
            this.viewBreadcrumbItem.setLabel(this.parentViewLabel);
        }
        if (StringUtils.isNotBlank((String)this.parentPageUrl.getOriginalHref()) || StringUtils.isNotBlank((String)this.parentPageUrl.getViewId()) && StringUtils.isNotBlank((String)this.parentPageUrl.getControllerMapping())) {
            this.pageBreadcrumbItem.setUrl(this.parentPageUrl);
            this.pageBreadcrumbItem.setLabel(this.parentPageLabel);
        }
        if (this.viewBreadcrumbItem.getUrl() == null || StringUtils.isBlank((String)this.viewBreadcrumbItem.getUrl().getOriginalHref()) && StringUtils.isBlank((String)this.viewBreadcrumbItem.getUrl().getViewId())) {
            return this.resolvedBreadcrumbItems;
        }
        String parentViewId = this.viewBreadcrumbItem.getUrl().getViewId();
        String controllerMapping = this.viewBreadcrumbItem.getUrl().getControllerMapping();
        View parentView = null;
        if (this.viewBreadcrumbItem.getUrl() != null && StringUtils.isNotBlank((String)controllerMapping) && StringUtils.isNotBlank((String)parentViewId) && StringUtils.isBlank((String)this.viewBreadcrumbItem.getUrl().getOriginalHref())) {
            parentView = KRADServiceLocatorWeb.getDataDictionaryService().getViewById(parentViewId);
        }
        if (parentView != null) {
            this.processParentViewDerivedContent(parentView, parentViewId, view, currentModel, currentContext);
        }
        if (StringUtils.isNotEmpty((String)this.viewBreadcrumbItem.getLabel())) {
            this.resolvedBreadcrumbItems.add(this.viewBreadcrumbItem);
        }
        if (this.pageBreadcrumbItem != null && StringUtils.isNotEmpty((String)this.pageBreadcrumbItem.getLabel())) {
            this.resolvedBreadcrumbItems.add(this.pageBreadcrumbItem);
        }
        return this.resolvedBreadcrumbItems;
    }

    private void processParentViewDerivedContent(View parentView, String parentViewId, View currentView, Object currentModel, Map<String, Object> currentContext) {
        ViewLifecycle.getExpressionEvaluator().populatePropertyExpressionsFromGraph(parentView, false);
        if (parentView.getParentLocation() != null) {
            this.resolvedBreadcrumbItems.addAll(parentView.getParentLocation().constructParentLocationBreadcrumbItems(parentView, currentModel, currentContext));
        }
        this.handleLabelExpressions(parentView, currentModel, currentContext, ViewLifecycle.getExpressionEvaluator());
        if (StringUtils.isBlank((String)this.viewBreadcrumbItem.getLabel()) && parentView.getBreadcrumbItem() != null && StringUtils.isNotBlank((String)parentView.getBreadcrumbItem().getLabel())) {
            this.viewBreadcrumbItem.setLabel(parentView.getBreadcrumbItem().getLabel());
        } else if (StringUtils.isBlank((String)this.viewBreadcrumbItem.getLabel()) && StringUtils.isNotBlank((String)parentView.getHeaderText())) {
            this.viewBreadcrumbItem.setLabel(parentView.getHeaderText());
        }
        if (parentView.getBreadcrumbItem() != null && parentView.getBreadcrumbItem().getSiblingBreadcrumbComponent() != null && this.viewBreadcrumbItem.getSiblingBreadcrumbComponent() == null) {
            this.viewBreadcrumbItem.setSiblingBreadcrumbComponent(parentView.getBreadcrumbItem().getSiblingBreadcrumbComponent());
        }
        if (this.pageBreadcrumbItem != null && StringUtils.isNotBlank((String)this.pageBreadcrumbItem.getUrl().getPageId()) && StringUtils.isNotBlank((String)this.pageBreadcrumbItem.getUrl().getViewId()) && this.pageBreadcrumbItem.getUrl().getViewId().equals(parentViewId)) {
            this.handlePageBreadcrumb(parentView, currentModel);
        }
    }

    private void handleLabelExpressions(View parentView, Object currentModel, Map<String, Object> currentContext, ExpressionEvaluator expressionEvaluator) {
        try {
            BreadcrumbItem breadcrumbItem;
            Header header = parentView.getHeader();
            if (header != null) {
                if (StringUtils.isNotBlank((String)parentView.getPropertyExpressions().get("headerText"))) {
                    header.getPropertyExpressions().put("headerText", parentView.getPropertyExpressions().get("headerText"));
                }
                expressionEvaluator.evaluateExpressionsOnConfigurable(parentView, header, currentContext);
            }
            if ((breadcrumbItem = parentView.getBreadcrumbItem()) != null) {
                expressionEvaluator.evaluateExpressionsOnConfigurable(parentView, breadcrumbItem, currentContext);
            }
            if (this.pageBreadcrumbItem != null && this.pageBreadcrumbItem.getUrl() != null && StringUtils.isNotBlank((String)this.pageBreadcrumbItem.getUrl().getPageId())) {
                BreadcrumbItem breadcrumbItem2;
                PageGroup thePage = null;
                if (parentView.isSinglePageView() && parentView.getPage() != null) {
                    thePage = parentView.getPage();
                } else {
                    for (Component component : parentView.getItems()) {
                        if (!component.getId().equals(this.pageBreadcrumbItem.getUrl().getPageId())) continue;
                        thePage = (PageGroup)component;
                        break;
                    }
                }
                if (thePage == null) {
                    return;
                }
                ViewLifecycle.getExpressionEvaluator().populatePropertyExpressionsFromGraph(thePage, false);
                Header pageHeader = thePage.getHeader();
                if (pageHeader != null) {
                    if (StringUtils.isNotBlank((String)thePage.getPropertyExpressions().get("headerText"))) {
                        pageHeader.getPropertyExpressions().put("headerText", thePage.getPropertyExpressions().get("headerText"));
                    }
                    expressionEvaluator.evaluateExpressionsOnConfigurable(parentView, pageHeader, currentContext);
                }
                if ((breadcrumbItem2 = thePage.getBreadcrumbItem()) != null) {
                    expressionEvaluator.evaluateExpressionsOnConfigurable(parentView, breadcrumbItem2, currentContext);
                }
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("There was likely a problem evaluating an expression in a parent view or page because a property may not exist in the current context - explicitly set the label for this parentLocation: " + parentView.getId(), e);
        }
    }

    private void handleExpressions(View view, Object currentModel, Map<String, Object> currentContext, ExpressionEvaluator expressionEvaluator) {
        try {
            expressionEvaluator.initializeEvaluationContext(currentModel);
            expressionEvaluator.evaluateExpressionsOnConfigurable(view, this.viewBreadcrumbItem, currentContext);
            if (this.viewBreadcrumbItem.getUrl() != null) {
                expressionEvaluator.evaluateExpressionsOnConfigurable(view, this.viewBreadcrumbItem.getUrl(), currentContext);
            }
            if (this.parentViewUrl != null) {
                expressionEvaluator.evaluateExpressionsOnConfigurable(view, this.parentViewUrl, currentContext);
            }
            if (this.pageBreadcrumbItem != null) {
                expressionEvaluator.evaluateExpressionsOnConfigurable(view, this.pageBreadcrumbItem, currentContext);
                if (this.pageBreadcrumbItem.getUrl() != null) {
                    expressionEvaluator.evaluateExpressionsOnConfigurable(view, this.pageBreadcrumbItem.getUrl(), currentContext);
                }
            }
            if (this.parentPageUrl != null) {
                expressionEvaluator.evaluateExpressionsOnConfigurable(view, this.parentPageUrl, currentContext);
            }
        }
        catch (RuntimeException e) {
            throw new RuntimeException("There was likely a problem evaluating an expression in a parent view or page because a property may not exist in the current context - problem in Url or BreadcrumbItem - set these to something that can be evaluated - of the parentLocation: " + view.getId(), e);
        }
    }

    private void handlePageBreadcrumb(View view, Object currentModel) {
        PageGroup thePage = null;
        if (view.isSinglePageView() && view.getPage() != null) {
            thePage = view.getPage();
        } else {
            for (Component component : view.getItems()) {
                if (!component.getId().equals(this.pageBreadcrumbItem.getUrl().getPageId())) continue;
                thePage = (PageGroup)component;
                break;
            }
        }
        if (thePage == null) {
            return;
        }
        if (StringUtils.isBlank((String)this.pageBreadcrumbItem.getLabel()) && thePage.getBreadcrumbItem() != null && StringUtils.isNotBlank((String)thePage.getBreadcrumbItem().getLabel())) {
            this.pageBreadcrumbItem.setLabel(thePage.getBreadcrumbItem().getLabel());
        } else if (StringUtils.isBlank((String)this.pageBreadcrumbItem.getLabel()) && StringUtils.isNotBlank((String)thePage.getHeaderText())) {
            this.pageBreadcrumbItem.setLabel(thePage.getHeaderText());
        }
        if (thePage.getBreadcrumbItem() != null && thePage.getBreadcrumbItem().getSiblingBreadcrumbComponent() != null && this.pageBreadcrumbItem.getSiblingBreadcrumbComponent() == null) {
            this.pageBreadcrumbItem.setSiblingBreadcrumbComponent(thePage.getBreadcrumbItem().getSiblingBreadcrumbComponent());
        }
    }

    @BeanTagAttribute(name="parentViewUrl", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public UrlInfo getParentViewUrl() {
        return this.parentViewUrl;
    }

    public void setParentViewUrl(UrlInfo parentViewUrl) {
        this.parentViewUrl = parentViewUrl;
    }

    @BeanTagAttribute(name="parentPageUrl", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public UrlInfo getParentPageUrl() {
        return this.parentPageUrl;
    }

    public void setParentPageUrl(UrlInfo parentPageUrl) {
        this.parentPageUrl = parentPageUrl;
    }

    @BeanTagAttribute(name="parentViewLabel")
    public String getParentViewLabel() {
        return this.parentViewLabel;
    }

    public void setParentViewLabel(String parentViewLabel) {
        this.parentViewLabel = parentViewLabel;
    }

    @BeanTagAttribute(name="parentPageLabel")
    public String getParentPageLabel() {
        return this.parentPageLabel;
    }

    public void setParentPageLabel(String parentPageLabel) {
        this.parentPageLabel = parentPageLabel;
    }

    @BeanTagAttribute(name="viewBreadcrumbItem", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BreadcrumbItem getViewBreadcrumbItem() {
        return this.viewBreadcrumbItem;
    }

    public void setViewBreadcrumbItem(BreadcrumbItem breadcrumbItem) {
        this.viewBreadcrumbItem = breadcrumbItem;
    }

    @BeanTagAttribute(name="pageBreadcrumbItem", type=BeanTagAttribute.AttributeType.SINGLEBEAN)
    public BreadcrumbItem getPageBreadcrumbItem() {
        return this.pageBreadcrumbItem;
    }

    public void setPageBreadcrumbItem(BreadcrumbItem pageBreadcrumbItem) {
        this.pageBreadcrumbItem = pageBreadcrumbItem;
    }

    public List<BreadcrumbItem> getResolvedBreadcrumbItems() {
        return this.resolvedBreadcrumbItems;
    }
}

