/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.concurrent.Callable;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.LegacyDetector;

public final class LegacyUtils {
    private static LegacyDetector ld = new LegacyDetector(KradDataServiceLocator.getMetadataRepository(), KRADServiceLocatorWeb.getDataDictionaryService());

    private LegacyUtils() {
        throw new UnsupportedOperationException(String.valueOf(LegacyUtils.class) + " should not be constructed");
    }

    public static boolean isLegacyManaged(Class<?> type) {
        return ld.isLegacyManaged(type);
    }

    public static boolean isKradDataManaged(Class<?> type) {
        return ld.isKradDataManaged(type);
    }

    public static boolean isKnsDocumentEntry(DocumentEntry documentEntry) {
        return "org.kuali.rice.kns.datadictionary".equals(documentEntry.getClass().getPackage().getName());
    }

    public static boolean isKnsEnabled() {
        return ld.isKnsEnabled();
    }

    public static boolean isLegacyDataFrameworkEnabled() {
        return ld.isLegacyDataFrameworkEnabled();
    }

    public static boolean useLegacy(Class<?> dataObjectClass) {
        return ld.useLegacy(dataObjectClass);
    }

    public static boolean useLegacyForObject(Object dataObject) {
        return ld.useLegacyForObject(dataObject);
    }

    public static boolean isInLegacyContext() {
        return ld.isInLegacyContext();
    }

    public static void beginLegacyContext() {
        ld.beginLegacyContext();
    }

    public static void endLegacyContext() {
        ld.endLegacyContext();
    }

    public static <T> T doInLegacyContext(Callable<T> callable) throws Exception {
        LegacyUtils.beginLegacyContext();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            LegacyUtils.endLegacyContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T doInLegacyContext(String documentId, UserSession userSession, Callable<T> callable) throws Exception {
        boolean inLegacyContext = LegacyUtils.establishLegacyDataContextIfNecessary(documentId);
        try {
            T t = GlobalVariables.doInNewGlobalVariables(userSession, callable);
            return t;
        }
        finally {
            LegacyUtils.clearLegacyDataContextIfExists(inLegacyContext);
        }
    }

    private static boolean establishLegacyDataContextIfNecessary(String documentId) {
        String documentTypeName = KewApiServiceLocator.getWorkflowDocumentService().getDocumentTypeName(documentId);
        DocumentEntry documentEntry = KRADServiceLocatorWeb.getDocumentDictionaryService().getDocumentEntry(documentTypeName);
        if (LegacyUtils.isKnsDocumentEntry(documentEntry)) {
            LegacyUtils.beginLegacyContext();
            return true;
        }
        return false;
    }

    private static void clearLegacyDataContextIfExists(boolean inLegacyContext) {
        if (inLegacyContext) {
            LegacyUtils.endLegacyContext();
        }
    }
}

