/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.web.form;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.util.SessionTransient;
import org.kuali.rice.krad.web.form.UifFormBase;

public class UifFormManager
implements Serializable {
    private static final long serialVersionUID = -6323378881342207080L;
    private int maxNumberOfSessionForms = 5;
    protected Vector accessedFormKeys = new Vector();
    protected Map<String, UifFormBase> sessionForms = new HashMap<String, UifFormBase>();

    public UifFormManager() {
        String maxNumberOfSessionFormsConfig;
        if (CoreApiServiceLocator.getKualiConfigurationService() != null && StringUtils.isNotBlank((String)(maxNumberOfSessionFormsConfig = CoreApiServiceLocator.getKualiConfigurationService().getPropertyValueAsString("maxNumberOfSessionForms")))) {
            this.maxNumberOfSessionForms = Integer.parseInt(maxNumberOfSessionFormsConfig);
        }
    }

    public synchronized void addSessionForm(UifFormBase form) {
        if (form == null || StringUtils.isBlank((String)form.getFormKey())) {
            throw new RiceIllegalArgumentException("Form or form key was null");
        }
        this.sessionForms.put(form.getFormKey(), form);
        if (this.accessedFormKeys.contains(form.getFormKey())) {
            this.accessedFormKeys.removeElement(form.getFormKey());
        }
        this.accessedFormKeys.add(form.getFormKey());
        if (this.sessionForms.size() > this.maxNumberOfSessionForms) {
            String removeFormKey = (String)this.accessedFormKeys.get(0);
            if (this.sessionForms.containsKey(removeFormKey)) {
                this.sessionForms.remove(removeFormKey);
            }
            this.accessedFormKeys.removeElementAt(0);
        }
    }

    public UifFormBase getSessionForm(String formKey) {
        if (this.sessionForms.containsKey(formKey)) {
            return this.sessionForms.get(formKey);
        }
        return null;
    }

    public void removeSessionForm(UifFormBase form) {
        if (form == null || StringUtils.isBlank((String)form.getFormKey())) {
            return;
        }
        this.removeSessionFormByKey(form.getFormKey());
    }

    public void removeFormWithHistoryFormsByKey(String formKey) {
        if (this.sessionForms.containsKey(formKey)) {
            this.removeSessionFormByKey(formKey);
        }
    }

    public void removeSessionFormByKey(String formKey) {
        if (this.accessedFormKeys.contains(formKey)) {
            this.accessedFormKeys.removeElement(formKey);
        }
        if (this.sessionForms.containsKey(formKey)) {
            this.sessionForms.remove(formKey);
        }
    }

    public boolean hasSessionForm(String formKey) {
        return this.sessionForms.containsKey(formKey);
    }

    public void updateFormWithSession(UifFormBase requestForm, String formKey) {
        UifFormBase sessionForm = this.sessionForms.get(formKey);
        if (sessionForm == null) {
            return;
        }
        if (!sessionForm.getClass().isAssignableFrom(requestForm.getClass())) {
            throw new RuntimeException("Session form mismatch, session form class not assignable from request form class");
        }
        List<Field> fields = new ArrayList<Field>();
        fields = this.getAllFields(fields, sessionForm.getClass(), UifFormBase.class);
        for (Field field : fields) {
            boolean copyValue = true;
            for (Annotation an : field.getAnnotations()) {
                if (!(an instanceof SessionTransient)) continue;
                copyValue = false;
            }
            if (!copyValue || !ObjectPropertyUtils.isReadableProperty(sessionForm, field.getName()) || !ObjectPropertyUtils.isWritableProperty(sessionForm, field.getName())) continue;
            Object fieldValue = ObjectPropertyUtils.getPropertyValue(sessionForm, field.getName());
            ObjectPropertyUtils.setPropertyValue(requestForm, field.getName(), fieldValue);
        }
    }

    public void purgeForm(UifFormBase form) {
        List<Field> fields = new ArrayList<Field>();
        fields = this.getAllFields(fields, form.getClass(), UifFormBase.class);
        for (Field field : fields) {
            boolean purgeValue = false;
            if (!field.getType().isPrimitive()) {
                for (Annotation an : field.getAnnotations()) {
                    if (!(an instanceof SessionTransient)) continue;
                    purgeValue = true;
                }
            }
            if (!purgeValue || !ObjectPropertyUtils.isWritableProperty(form, field.getName())) continue;
            ObjectPropertyUtils.setPropertyValue(form, field.getName(), null);
        }
    }

    private List<Field> getAllFields(List<Field> fields, Class<?> type, Class<?> stopAt) {
        for (Field field : type.getDeclaredFields()) {
            fields.add(field);
        }
        if (type.getSuperclass() != null && !type.getName().equals(stopAt.getName())) {
            fields = this.getAllFields(fields, type.getSuperclass(), stopAt);
        }
        return fields;
    }

    protected Vector getAccessedFormKeys() {
        return this.accessedFormKeys;
    }

    public int getMaxNumberOfSessionForms() {
        return this.maxNumberOfSessionForms;
    }

    public void setMaxNumberOfSessionForms(int maxNumberOfSessionForms) {
        this.maxNumberOfSessionForms = maxNumberOfSessionForms;
    }
}

