/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * This element is used to define a set of workflowPropertyGroups, which are used to
 * specify which document properties should be serialized during the document serialization
 * process.
 */
@BeanTag(name = "workflowProperties")
public class WorkflowProperties implements Serializable {
    private static final long serialVersionUID = 1L;

    protected List<WorkflowPropertyGroup> workflowPropertyGroups;

    public WorkflowProperties() {
        workflowPropertyGroups = new ArrayList<WorkflowPropertyGroup>();
    }

    /**
     * Returns a list of workflow property groups, which are used to determine which properties should be serialized
     * when generating
     * routing XML
     *
     * @return a list of {@link WorkflowPropertyGroup} objects, in the order in which they were added
     */
    @BeanTagAttribute(name = "workflowPropertyGroups", type = BeanTagAttribute.AttributeType.LISTBEAN)
    public List<WorkflowPropertyGroup> getWorkflowPropertyGroups() {
        return this.workflowPropertyGroups;
    }

    /**
     * This element is used to define a set of workflowPropertyGroups, which are used to
     * specify which document properties should be serialized during the document serialization
     * process.
     */
    public void setWorkflowPropertyGroups(List<WorkflowPropertyGroup> workflowPropertyGroups) {
        this.workflowPropertyGroups = workflowPropertyGroups;
    }

}
