/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

import java.util.Map;

/**
 * Control instance that implements a callback for processing lookup search criteria.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface FilterableLookupCriteriaControl {

    /**
     * Returns the post data for the filterable lookup criteria control using the property name as a key.
     *
     * @param propertyName the property name for the control
     *
     * @return the post data for the filterable lookup criteria control
     */
    FilterableLookupCriteriaControlPostData getPostData(String propertyName);

    /**
     * Invoked to perform filtering of the search criteria.
     *
     * @param propertyName the propertyName of the current component
     * @param searchCriteria the search criteria to be filtered
     * @param postData the post data to consider during the search
     *
     * @return filtered search criteria
     */
    Map<String, String> filterSearchCriteria(String propertyName, Map<String, String> searchCriteria, FilterableLookupCriteriaControlPostData postData);

}
