/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

/**
 * Defines the post data to send for filtering search results for a filterable control.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface FilterableLookupCriteriaControlPostData {

    /**
     * Returns the class to invoke the filter search method on.
     *
     * @return the class to invoke the filter search method on
     */
    Class<? extends FilterableLookupCriteriaControl> getControlClass();

    /**
     * Returns the property name of the control that this post data is representing.
     *
     * @return the property name of the control that this post data is representing
     */
    String getPropertyName();

}
