/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import java.util.List;

/**
 * Performs overrides on the fields of a Data Dictionary bean.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface BeanOverride {
    /**
     * Return the name of the bean to perform the override.
     *
     * @return bean name
     */
    public String getBeanName();

    /**
     * Returns the list of fields to perform the override.
     */
    public List<FieldOverride> getFieldOverrides();

    /**
     * Perform the override logic on the specific bean.
     */
    public void performOverride(Object bean);
}
