/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.impl;

import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;

import java.util.Comparator;
import java.util.List;

/**
 * The super class which implementations of the FieldOverride interface will extend.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class FieldOverrideForListElementBase {

    private String propertyName;
    private Object element;
    protected String propertyNameForElementCompare;

    public String getPropertyNameForElementCompare() {
        return propertyNameForElementCompare;
    }

    public void setPropertyNameForElementCompare(String propertyNameForElementCompare) {
        this.propertyNameForElementCompare = propertyNameForElementCompare;
    }

    protected int getElementPositionInList(Object object, List theList) {
        Comparator comparator = this.getComparator();
        int pos = -1;

        if (object != null && theList != null) {
            for (int i = 0; i < theList.size(); ++i) {
                Object item = theList.get(i);
                boolean equalFlag = false;
                if (comparator != null) {
                    equalFlag = comparator.compare(object, item) == 0;
                } else {
                    equalFlag = item.equals(object);
                }
                if (equalFlag) {
                    pos = i;
                    break;
                }
            }
        }
        return pos;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Object getElement() {
        return element;
    }

    public void setElement(Object value) {
        this.element = value;
    }

    public FieldOverrideForListElementBase() {
        super();
    }

    protected Comparator getComparator() {
        Comparator comparator = null;
        if (StringUtils.isNotBlank(propertyNameForElementCompare)) {
            comparator = new BeanComparator(propertyNameForElementCompare);
        } else {
            throw new RuntimeException("Missing required comparator definitions.");
        }
        return comparator;
    }

}
