/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.result;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class EntryValidationResult {

    private String entryName;
    private Map<String, AttributeValidationResult> attributeValidationResultMap;

    public EntryValidationResult(String entryName) {
        this.entryName = entryName;
        this.attributeValidationResultMap = new LinkedHashMap<String, AttributeValidationResult>();
    }

    public Iterator<AttributeValidationResult> iterator() {
        return attributeValidationResultMap.values().iterator();
    }

    protected AttributeValidationResult getAttributeValidationResult(String attributeName) {
        AttributeValidationResult attributeValidationResult = attributeValidationResultMap.get(attributeName);
        if (attributeValidationResult == null) {
            attributeValidationResult = new AttributeValidationResult(attributeName);
            attributeValidationResultMap.put(attributeName, attributeValidationResult);
        }
        return attributeValidationResult;
    }

}
