/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.document;

import org.kuali.rice.krad.web.form.TransactionalDocumentFormBase;
import org.springframework.web.servlet.ModelAndView;

/**
 * Controller service that extends {@link org.kuali.rice.krad.document.DocumentControllerService} and adds
 * methods specific to transactional documents.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface TransactionalDocumentControllerService extends DocumentControllerService {

    /**
     * Invoked to copy the current transactional document into a new document.
     *
     * @param form form instance containing the transactional document data
     * @return ModelAndView instance for rendering the document view
     */
    ModelAndView copy(TransactionalDocumentFormBase form);
}
