/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.document;

/**
* Document presentation controller implementation for transactional documents.
*
* <p>
* Determines what actions are applicable to the given document, irrespective of user
* or other state.  These initial actions are used as inputs for further filtering depending
* on context.
* </p>
*
* @see DocumentPresentationController
* @author Kuali Rice Team (rice.collab@kuali.org)
*/
public class TransactionalDocumentPresentationControllerBase extends DocumentPresentationControllerBase implements TransactionalDocumentPresentationController {

    private static final long serialVersionUID = 6830255382171510618L;

    /**
     * {@inheritDoc}
     *
     * A document should only show its close button if it is a transactional document, since closing releases its
     * pessimistic locks.
     */
    @Override
    public boolean canClose(Document document) {
        return true;
    }

}
