/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.maintenance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *  Default implementation of {@link BulkUpdateMaintenanceDataObject}.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class BulkUpdateMaintenanceDataObjectBase implements BulkUpdateMaintenanceDataObject {
    private static final long serialVersionUID = -2703891255485833554L;

    private Map<String, ?> updateFieldValues = new HashMap<String, Object>();

    private List<?> targetUpdateDataObjects = new ArrayList<Object>();

    /**
     * @see BulkUpdateMaintenanceDataObjectBase#getUpdateFieldValues()
     */
    @Override
    public Map<String, ?> getUpdateFieldValues() {
        return updateFieldValues;
    }

    /**
     * @see BulkUpdateMaintenanceDataObjectBase#getTargetUpdateDataObjects()
     */
    @Override
    public List<?> getTargetUpdateDataObjects() {
        return targetUpdateDataObjects;
    }

}
