/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.rules.rule.event;

import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.AddNoteRule;
import org.kuali.rice.krad.rules.rule.BusinessRule;

/**
 * This class represents the add note event that is part of an eDoc in Kuali. This is triggered when a user presses the add button
 * for a given note or it could happen when another piece of code calls the create note method in the document service.
 *
 *
 */
public final class AddNoteEvent extends DocumentEventBase {
    private Note note;

    /**
     * Constructs an AddNoteEvent with the specified errorPathPrefix and document
     *
     * @param document
     * @param errorPathPrefix
     */
    public AddNoteEvent(String errorPathPrefix, Document document, Note note) {
        super("creating add note event for document " + DocumentEventBase.getDocumentId(document), errorPathPrefix, document);
        this.note = note;
    }

    /**
     * Constructs an AddNoteEvent with the given document
     *
     * @param document
     */
    public AddNoteEvent(Document document, Note note) {
        this("", document, note);
    }

    /**
     * This method retrieves the note associated with this event.
     *
     * @return note
     */
    public Note getNote() {
        return note;
    }

    @Override
    public void validate() {
        super.validate();
        if (getNote() == null) {
            throw new IllegalArgumentException("invalid (null) note");
        }
    }

    /**
     * @see org.kuali.rice.krad.rules.rule.event.RuleEvent#getRuleInterfaceClass()
     */
    @Override
    public Class<? extends BusinessRule> getRuleInterfaceClass() {
        return AddNoteRule.class;
    }

    /**
     * @see org.kuali.rice.krad.rules.rule.event.RuleEvent#invokeRuleMethod(org.kuali.rice.krad.rules.rule.BusinessRule)
     */
    @Override
    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddNoteRule) rule).processAddNote(getDocument(), getNote());
    }
}
