/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.rules.rule.event;

import org.kuali.rice.krad.document.Document;

/**
 * This class represents the blanketApprove event that is part of an eDoc in Kuali. This could be triggered when a user presses the
 * blanketApprove button for a given document enroute or it could happen when another piece of code calls the blanketApprove method
 * in the document service.
 *
 *
 */
public final class BlanketApproveDocumentEvent extends ApproveDocumentEvent {
    /**
     * Constructs an BlanketApproveDocumentEvent with the specified errorPathPrefix and document
     *
     * @param errorPathPrefix
     * @param document
     */
    public BlanketApproveDocumentEvent(String errorPathPrefix, Document document) {
        super("blanketApprove", errorPathPrefix, document);
    }

    /**
     * Constructs a BlanketApproveDocumentEvent with the given document
     *
     * @param document
     */
    public BlanketApproveDocumentEvent(Document document) {
        super("blanketApprove", "", document);
    }
}
