/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.rules.rule.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by nigupta on 4/28/2014.
 */
abstract public class RuleEventBase implements RuleEvent {

    private String name;
    private final String description;
    private final String errorPathPrefix;
    private Map<String, Object> facts = new HashMap<String, Object>();
    private String ruleMethodName;

    /**
     * As a general rule, business rule classes should not change the original object. This constructor was created so
     * that PreRulesCheckEvent, a UI level rule checker, can make changes.
     *
     * @param description
     * @param errorPathPrefix
     */
    public RuleEventBase( String description, String errorPathPrefix ) {
        this.description = description;
        this.errorPathPrefix = errorPathPrefix;
    }

    public void addFact( String key, Object object ) {
        facts.put( key, object );
    }

    /**
     * the name of this event
     * @return - the event name
     */
    @Override
    public String getName() {
        return name;
    }

    /**
     * @see RuleEventBase#getName()
     */
    public void setName( String name ) {
        this.name = name;
    }

    /**
     * @return a description of this event
     */
    @Override
    public final String getDescription() {
        return description;
    }

    /**
     * @return the error path prefix for this event
     */
    @Override
    public String getErrorPathPrefix() {
        return errorPathPrefix;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return getName();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Map<String, Object> getFacts() {
        return facts;
    }

    /**
     * @see RuleEventBase#getFacts()
     */
    public void setFacts( Map<String, Object> facts ) {
        this.facts = facts;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getRuleMethodName() {
        return ruleMethodName;
    }

    /**
     * @see RuleEventBase#getRuleMethodName()
     */
    public void setRuleMethodName( String name ) {
        this.ruleMethodName = name;
    }

    /**
     * @see org.kuali.rice.krad.rules.rule.event.RuleEvent#generateEvents()
     */
    @Override
    public List<RuleEvent> generateEvents() {
        return new ArrayList<RuleEvent>();
    }
}
