/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import java.util.List;

import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.document.Document;

/**
 * This service populates {@link Document}s with {@link AdHocRoutePerson}s and {@link AdHocRouteWorkgroup}s
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DocumentAdHocService {

	/**
	 * This method populates the given {@link Document} with the {@link AdHocRoutePerson}s and {@link AdHocRouteWorkgroup}s
	 * that are associated with it.
	 *
	 */
	void addAdHocs(Document doc);

	/**
	 * This method replaces the current ad-hoc recipients for a given document.
	 *
	 */
	void replaceAdHocsForDocument(Document doc);
}
