/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.layout.collections;

import org.kuali.rice.krad.uif.field.Field;

import java.io.Serializable;
import java.util.List;

/**
 * Holds the components that make up a row within the table layout.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @see org.kuali.rice.krad.uif.layout.TableLayoutManager
 */
public class TableRow implements Serializable {
    private static final long serialVersionUID = -3566983879980459225L;

    private List<Field> columns;

    /**
     * Empty Constructor.
     */
    public TableRow() {

    }

    /**
     * Constructor with columns for the row.
     *
     * @param columns list of fields that make up the row's columns
     */
    public TableRow(List<Field> columns) {
        this.columns = columns;
    }

    /**
     * List of field components that make up the row's columns.
     *
     * @return list of field components
     */
    public List<Field> getColumns() {
        return columns;
    }

    /**
     * @see TableRow#getColumns()
     */
    public void setColumns(List<Field> columns) {
        this.columns = columns;
    }

    /**
     * Returns the field instance that makes up the column with the given index.
     *
     * @param columnIndex index for the column to return
     * @return field instance at that column, or null if column does not exist
     */
    public Field getColumn(int columnIndex) {
        Field column = null;

        if ((this.columns != null) && (this.columns.size() > columnIndex)) {
            column = this.columns.get(columnIndex);
        }

        return column;
    }

    /**
     * Returns the number of columns within the row.
     *
     * @return number of columns
     */
    public int getNumberOfColumns() {
        if (this.columns != null) {
            return this.columns.size();
        }

        return 0;
    }
}
