/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for {@link org.kuali.rice.krad.uif.util.LifecycleElement} bean properties to restrict which view
 * lifecycle phases for which the property will be considered while initializing the successor phase queue.
 * 
 * <p>
 * This annotation should be placed on the read method for any properties on the component that
 * should be excluded from the view lifecycle. An optional array of phases at which the property
 * should be included may be provided.
 * </p>
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ViewLifecycleRestriction {

    /**
     * Lifecycle phase (including preceding phases) at which to include the annotated bean property.
     * 
     * @return lifecycle phase at which to include the annotated property
     * @see org.kuali.rice.krad.uif.UifConstants.ViewPhases
     */
    String[] value() default {};

    /**
     * Lifecycle phase(s) at which to exclude the annotated bean property.
     *
     * <p>Note when this property is set by itself, all other phases not listed will be included. If value is
     * set as well, only those phases within the value and not listed here will be included.</p>
     *
     * @return set of lifecycle phases at which to exclude the annotated property
     * @see org.kuali.rice.krad.uif.UifConstants.ViewPhases
     */
    String[] exclude() default {};

    /**
     * Expression to evaluate (must result in boolean) that will determine if the property is included
     * at the configured phases.
     *
     * <p>Expressions have access to the model as the default context. Also, no expression syntax (@{}) should
     * be used.</p>
     *
     * @return String condition to evaluate
     */
    String condition() default "";

}
