/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.util;

import org.kuali.rice.core.api.util.AbstractKeyValue;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;

/**
 * KeyValue that has an additional label property for hierarchical dropdowns.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "optionGroupLabel-bean", parent = "Uif-OptionGroupLabel")
public class UifOptionGroupLabel extends AbstractKeyValue {
    private static final long serialVersionUID = -839111602450208876L;

    private String label;

    /**
     * Base constructor
     */
    public UifOptionGroupLabel() {
        super();
        this.key = "NA";
        this.value = "NA";
    }

    public UifOptionGroupLabel(String label) {
        this.key = "NA";
        this.value = "NA";
        this.label = label;
    }

    /**
     * Get the label for the option group.
     *
     * @return the label
     */
    @BeanTagAttribute(name = "label")
    public String getLabel() {
        return label;
    }

    /**
     * @see #getLabel()
     */
    public void setLabel(String label) {
        this.label = label;
    }

}
