/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import java.io.Serializable;

/**
 * Common interface for all objects that can be configured in the dictionary
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface DictionaryBean extends Serializable {

    /**
     * Namespace code (often an application or module code) that dictionary bean is associated with
     *
     * <p>
     * Note this may be assigned through the bean definition itself, or associated by the module configuration
     * and its dictionary files
     * </p>
     *
     * @return String namespace code
     */
    public String getNamespaceCode();

    /**
     * A code within the namespace that identifies a component or group the bean is associated with
     *
     * @return String representing a component code
     */
    public String getComponentCode();

    /**
     * Perform any needed post-processing of the bean properties.  This will be called
     * starting at the parent data object entry or document entry class and recursed down
     * though all other DictionaryBean objects contained within.
     */
    public void dataDictionaryPostProcessing();
}
