/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.KRADConstants;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Allows for grouping of related {@link WorkflowProperty} objects
 *
 * <p>
 * This element is used to define a set of workflowProperty tags, which are used to
 * specify which document properties should be serialized during the document serialization
 * process.  This element allows for all the nested workflowProperty tags to be relative
 * to some base path.  This base path itself is relative to the object being serialized
 * during the document serialization process (which is not necessarily the document itself,
 * but a wrapper around the document).If blank/missing, the base path will be assumed to be
 * the property path to the document.
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "workflowPropertyGroup")
public class WorkflowPropertyGroup implements Serializable {
    private static final long serialVersionUID = 1L;

    protected String basePath = KRADConstants.EMPTY_STRING;
    protected List<WorkflowProperty> workflowProperties = new ArrayList<WorkflowProperty>();

    /**
     * The list of {@link WorkflowProperty} objects
     *
     * @return List&lt;WorkflowProperty&gt;
     */
    @BeanTagAttribute(name = "workflowProperties", type = BeanTagAttribute.AttributeType.LISTBEAN)
    public List<WorkflowProperty> getWorkflowProperties() {
        return workflowProperties;
    }

    /**
     * The base path of the group which all {@link WorkflowProperty} objects are relative to
     *
     * <p>
     * The base path itself should be relative from the object being serialized, which may not necessarily be the
     * document, see {@link Document#wrapDocumentWithMetadataForXmlSerialization()}
     * and {@link Document#getBasePathToDocumentDuringSerialization()}. If blank/missing, the base path will be
     * assumed to be the property path to the document.
     * </p>
     *
     * @return String
     */
    @BeanTagAttribute(name = "basePath")
    public String getBasePath() {
        return this.basePath;
    }

    /**
     * Setter for the base path
     *
     * @param basePath - the base path
     */
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    /**
     * Setter for workflow properties list
     *
     * @param workflowProperties - the list of workflow properties
     */
    public void setWorkflowProperties(List<WorkflowProperty> workflowProperties) {
        this.workflowProperties = workflowProperties;
    }

}
