/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.impl;

import org.kuali.rice.krad.datadictionary.FieldOverride;

import java.util.List;

/**
 * A Field Override used to insert elements into a Data Dictionary Bean.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class FieldOverrideForListElementInsertImpl extends FieldOverrideForListElementBase implements FieldOverride {

    private Object insertBefore;
    private Object insertAfter;

    public Object getInsertBefore() {
        return insertBefore;
    }

    public void setInsertBefore(Object insertBefore) {
        this.insertBefore = insertBefore;
    }

    public Object getInsertAfter() {
        return insertAfter;
    }

    public void setInsertAfter(Object insertAfter) {
        this.insertAfter = insertAfter;
    }

    protected void varifyConfig() {
        if (insertBefore != null && insertAfter != null) {
            throw new RuntimeException("Configuration Error, insertBefore and insertAfter can not be both NOT-NULL");
        }
        if (insertBefore == null && insertAfter == null) {
            throw new RuntimeException("Configuration Error, Either insertBefore or insertAfter should be NOT-NULL");
        }
    }

    private Object getObjectToInsert() {
        Object objToInsert = null;
        if (insertBefore != null) {
            objToInsert = insertBefore;
        }
        if (insertAfter != null) {
            if (objToInsert != null) {
                throw new RuntimeException(
                        "Configuration Error, insertBefore and insertAfter can not be both NOT-NULL");
            }
            objToInsert = insertAfter;
        }
        if (objToInsert == null) {
            throw new RuntimeException("Configuration Error, Either insertBefore or insertAfter must be NOT-NULL");
        }
        return objToInsert;
    }

    @Override
    public Object performFieldOverride(Object bean, Object property) {
        Object objToInsert = getObjectToInsert();

        List oldList = (List) property;

        int insertPos = getElementPositionInList(getElement(), oldList);

        if (insertPos == -1) {
            insertPos = oldList.size();
        } else {
            if (insertAfter != null) {
                insertPos = insertPos + 1;
            }
        }

        if (objToInsert instanceof List) {
            oldList.addAll(insertPos, (List) objToInsert);
        } else {
            oldList.add(insertPos, objToInsert);
        }
        return oldList;
    }
}
