/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation;

/**
 * Enum inherited from the Kuali Student project to track error levels in validation.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public enum ErrorLevel {
    NOCONSTRAINT(-2), INAPPLICABLE(-1), OK(0), WARN(1), ERROR(2);

    int level;

    private ErrorLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return level;
    }

    public static ErrorLevel min(ErrorLevel e1, ErrorLevel e2) {
        return e1.ordinal() < e2.ordinal() ? e1 : e2;
    }

    public static ErrorLevel max(ErrorLevel e1, ErrorLevel e2) {
        return e1.ordinal() > e2.ordinal() ? e1 : e2;
    }

}
