/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.UifConstants;

/**
 * Pattern for matching any printable character
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "anyCharacterPatternConstraint", parent="AnyCharacterPatternConstraint")
public class AnyCharacterPatternConstraint extends ValidCharactersPatternConstraint {
    protected boolean allowWhitespace = false;
    protected boolean omitNewline = false;

    /**
     * @return allowWhitespace
     */
    @BeanTagAttribute(name = "allowWhitespace")
    public boolean getAllowWhitespace() {
        return allowWhitespace;
    }

    /**
     * @param allowWhitespace
     */
    public void setAllowWhitespace(boolean allowWhitespace) {
        this.allowWhitespace = allowWhitespace;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected String getRegexString() {
        StringBuffer regexString = new StringBuffer("[");

        regexString.append("\\x21-\\x7E");
        if (allowWhitespace) {
            regexString.append("\\t\\v\\040");
            if (!omitNewline) {
                regexString.append("\\f\\r\\n");
            }
        }

        regexString.append("]");

        return regexString.toString();
    }

    /**
     * @see org.kuali.rice.krad.datadictionary.validation.constraint.BaseConstraint#getMessageKey()
     */
    @Override
    public String getMessageKey() {
        String labelKey = super.getMessageKey();
        if (StringUtils.isNotEmpty(labelKey)) {
            return labelKey;
        }

        if (!allowWhitespace) {
            return UifConstants.Messages.VALIDATION_MSG_KEY_PREFIX + "anyCharacterPatternNoWhitespace";
        } else {
            return UifConstants.Messages.VALIDATION_MSG_KEY_PREFIX + "anyCharacterPattern";
        }
    }

    @BeanTagAttribute(name = "omitNewline")
    public boolean isOmitNewline() {
        return omitNewline;
    }

    /**
     * When set to true, omit new line characters from the set of valid characters.  This flag
     * will only have an effect if the allowWhitespace flag is true, otherwise all whitespace
     * including new lines characters are omitted.
     *
     * @param omitNewline
     */
    public void setOmitNewline(boolean omitNewline) {
        this.omitNewline = omitNewline;
    }
}
