/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.datadictionary.validation.constraint.resolver;

import java.util.List;

import org.kuali.rice.krad.datadictionary.validation.capability.Constrainable;
import org.kuali.rice.krad.datadictionary.validation.constraint.Constraint;
import org.kuali.rice.krad.datadictionary.validation.constraint.provider.AttributeDefinitionConstraintProvider;

/**
 * ConstraintResolver provides a lookup of constraints for a specific constrainable attribute definition
 *
 * <p>Implemented by constraint
 * providers as a mechanism to store functional lookups in a map, keyed by constraint type, for example.</p>
 *
 * {@link AttributeDefinitionConstraintProvider} for a number of examples.
 *
 * @param <T> constrainable type
 * @author Kuali Rice Team (rice.collab@kuali.org)
 * @since 1.1
 */
public interface ConstraintResolver<T extends Constrainable> {

    /**
     * gets the list of constraints from the provided definition
     *
     * @param definition - a data dictionary definition
     * @param <C> - the java type of the constraint
     * @return - a list of constraints
     */
    public <C extends Constraint> List<C> resolve(T definition);

}
