/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.document;

import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

/**
 * Base class for transactional documents
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@MappedSuperclass
public abstract class TransactionalDocumentBase extends DocumentBase implements TransactionalDocument, SessionDocument {
    private static final long serialVersionUID = 1L;

    /**
     * EclipseLink static weaving does not weave MappedSuperclass unless an Entity or Embedded is
     * weaved which uses it, hence this class.
     */
    @Embeddable
    private static final class WeaveMe extends TransactionalDocumentBase {}

    // EclipseLink chokes with an NPE if a mapped superclass does not have any attributes.  This keeps it happy.
    @Transient
    transient private String eclipseLinkBugHackAttribute;
    
    /**
     * @see org.kuali.rice.krad.document.TransactionalDocument#getAllowsCopy()
     *      Checks if copy is set to true in data dictionary and the document instance implements
     *      Copyable.
     */
    @Override
    public boolean getAllowsCopy() {
        return this instanceof Copyable
                && KRADServiceLocatorWeb.getDocumentDictionaryService().getAllowsCopy(this).booleanValue();
    }

    /**
     * This method to check whether the document class implements SessionDocument
     *
     * @return true if the document is a session document
     */
    public boolean isSessionDocument() {
        return SessionDocument.class.isAssignableFrom(this.getClass());
    }
}
