/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.service;

import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.datadictionary.InactivationBlockingMetadata;

import java.util.List;

/**
 * A service that helps to print out records that block the inactivation of another BO
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface InactivationBlockingDisplayService {

    /**
	 * Retrieves a List of Strings representing each record that blocks the inactivation of blockedBo
	 *
	 * @param blockedBo
	 * @param inactivationBlockingMetadata the blocking relationship
	 * @return list of blocking records
     *
     * @deprecated use {@link #displayAllBlockingRecords(Object, org.kuali.rice.krad.datadictionary.InactivationBlockingMetadata)} instead
	 */
    @Deprecated
	List<String> listAllBlockerRecords(BusinessObject blockedBo, InactivationBlockingMetadata inactivationBlockingMetadata);

    /**
     * Retrieves a List of Strings representing each record that blocks the inactivation of blockedDataObject
     *
     * @param blockedDataObject
     * @param inactivationBlockingMetadata the blocking relationship
     * @return list of all bocking records
     */
    List<String> displayAllBlockingRecords(Object blockedDataObject, InactivationBlockingMetadata inactivationBlockingMetadata);

}
