/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.control;

import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.uif.util.KeyMessage;
import org.kuali.rice.krad.uif.view.View;
import java.util.List;

/**
 * Indicates <code>Control</code> types that can hold more than one value for selection
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface MultiValueControl {

    /**
     * <code>List</code> of values the control can accept. Each value consists
     * of a key and a label. The key is the what will be submitted back if the
     * user selects the choice, the label is what will be displayed to the user
     * for the choice.
     * <p>
     * <code>KeyLabelPair</code> instances are usually generated by the
     * <code>KeyValueFinder</code> associated with the <code>Field</code> for
     * which the control belongs
     * </p>
     *
     * @return List of KeyLabelPair instances
     */
    public List<KeyValue> getOptions();

    /**
     * Sets the List of <code>KeyValue</code> pairs that make up the options for the control
     *
     * @param options
     */
    public void setOptions(List<KeyValue> options);

    /**
     * Gets the richOptions which contain Message objects with the translated rich message structures, which then can
     * be used by templates to output the appropriate content.
     *
     * @return richOptions which include a message object with the translated value content
     */
    public List<KeyMessage> getRichOptions();
}
