/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle;

import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle.LifecycleEvent;

/**
 * Lifecycle phase processing task for initializing a component.
 *
 * <p>
 * During the initialize phase each component of the tree is invoked to setup state based on the
 * configuration and request options.
 * </p>
 *
 * <p>
 * The initialize phase is only called once per <code>View</code> lifecycle
 * </p>
 *
 * <p>
 * Note the <code>View</code> instance also contains the context Map that was created based on the
 * parameters sent to the view service
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class InitializeComponentPhase extends ViewLifecyclePhaseBase {

    /**
     * {@inheritDoc}
     *
     * @return UifConstants.ViewPhases.INITIALIZE
     */
    @Override
    public String getViewPhase() {
        return UifConstants.ViewPhases.INITIALIZE;
    }

    /**
     * {@inheritDoc}
     * return UifConstants.ViewStatus.CREATED
     */
    @Override
    public String getStartViewStatus() {
        return UifConstants.ViewStatus.CREATED;
    }

    /**
     * {@inheritDoc}
     *
     * @return UifConstants.ViewStatus.INITIALIZED
     */
    @Override
    public String getEndViewStatus() {
        return UifConstants.ViewStatus.INITIALIZED;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LifecycleEvent getEventToNotify() {
        return null;
    }

}
