/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.lifecycle.finalize;

import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleTaskBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.view.ViewModel;

/**
 * Sets data bindings to read-only at the end of the apply model phase.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class SetReadOnlyOnDataBindingTask extends ViewLifecycleTaskBase<DataBinding> {

    public SetReadOnlyOnDataBindingTask() {
        super(DataBinding.class);
    }

    @Override
    protected void performLifecycleTask() {
        // implement readonly request overrides
        LifecycleElement element = getElementState().getElement();
        ViewModel viewModel = (ViewModel) ViewLifecycle.getModel();
        if ((element instanceof DataBinding)
                && ViewLifecycle.getView().isSupportsRequestOverrideOfReadOnlyFields()
                && !viewModel.getReadOnlyFieldsList().isEmpty()) {
            DataBinding dataBinding = (DataBinding) element;
            String propertyName = dataBinding.getPropertyName();
            if (viewModel.getReadOnlyFieldsList().contains(propertyName)) {
                ((Component) dataBinding).setReadOnly(true);
            }
        }
    }

}
