/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.util;

import org.kuali.rice.core.api.util.AbstractKeyValue;
import org.kuali.rice.krad.uif.element.Message;

/**
 * KeyMessage object for key-value pairs that contain rich content in the value portion.  By translating this content
 * to message, the content will be parsed and replaced appropriately for KeyValue controls.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class KeyMessage extends AbstractKeyValue {
    private Message message;

    /**
     * Constructor for KeyMessage
     *
     * @param key key
     * @param value value
     * @param message message with messageText set to value
     */
    public KeyMessage(String key, String value, Message message) {
        super(key, value);
        this.message = message;
    }

    /**
     * Constructor for KeyMessage
     *
     * @param key key
     * @param value value
     * @param message message with messageText set to value
     * @param disabled boolean whether to enable the key/value or not
     */
    public KeyMessage(String key, String value, Message message, boolean disabled) {
        this(key, value, message);
        this.disabled = disabled;
    }

    /**
     * Set the key
     *
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * Set the value
     *
     * @param value
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Get the message.  The message will contain the translated/parsed value after its lifecycle executes.
     *
     * @return message with translated structure
     */
    public Message getMessage() {
        return message;
    }

    /**
     * Set the message.  The message should have the rich message value as its messageText
     *
     * @param message
     */
    public void setMessage(Message message) {
        this.message = message;
    }


}
