/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.krad.uif.widget;

import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.uif.element.Header;

/**
 * Widget that renders text syntax highlighted
 *
 * <p>
 * The widget renders a div with a header. In the div the source code text will be added in pre tags with the
 * specified plugin class that is needed for the plugin to alter the text.
 * </p>
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
@BeanTag(name = "syntaxHighlighter", parent = "Uif-SyntaxHighlighter")
public class SyntaxHighlighter extends WidgetBase {

    private Header header;
    private String sourceCode;
    private String pluginCssClass;
    private boolean allowCopy;
    private boolean showCopyConfirmation;
    
    public SyntaxHighlighter() {
        super();
        allowCopy = true;
        showCopyConfirmation = false;
    }

    @BeanTagAttribute
    public Header getHeader() {
        return header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    /**
     * The text to render with syntax highlighting
     *
     * @return String
     */
    @BeanTagAttribute
    public String getSourceCode() {
        return sourceCode;
    }

    /**
     * Setter for the source code text
     *
     * @param sourceCode
     */
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    /**
     * The class that will be set on the pre tags
     *
     * <p>
     * The class is used by the prettify plugin to identify text to highlight and to specify type of highlighting.
     * </p>
     *
     * @return String
     */
    @BeanTagAttribute
    public String getPluginCssClass() {
        return pluginCssClass;
    }

    /**
     * Setter for the plugin css class
     *
     * @param pluginCssClass
     */
    public void setPluginCssClass(String pluginCssClass) {
        this.pluginCssClass = pluginCssClass;
    }

    /**
     * Indicates if the ZeroClipboard copy functionality must be added
     *
     * <p>
     * When copy is allowed a copy button will be shown when the mouse hovers over the syntax highlighter. This button
     * will be hidden the otherwise to avoid obstructing some of the displayed code.
     * </p>
     *
     * @return  boolean
     */
    @BeanTagAttribute
    public boolean isAllowCopy() {
        return allowCopy;
    }

    /**
     * Setter for the allow copy flag
     *
     * @param allowCopy
     */
    public void setAllowCopy(boolean allowCopy) {
        this.allowCopy = allowCopy;
    }

    /**
     * Indicates if a confirmation dialog must be shown after copy action
     *
     * @return boolean
     */
    @BeanTagAttribute
    public boolean isShowCopyConfirmation() {
        return showCopyConfirmation;
    }

    /**
     * Setter for the show copy confirmation dialog flag
     *
     * @param showCopyConfirmation
     */
    public void setShowCopyConfirmation(boolean showCopyConfirmation) {
        this.showCopyConfirmation = showCopyConfirmation;
    }
}
