/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.element;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.element.ContentElementBase;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleRestriction;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.MessageStructureUtils;

@BeanTag(name="message", parent="Uif-Message")
public class Message
extends ContentElementBase {
    private static final long serialVersionUID = 4090058533452450395L;
    private static final Logger LOG = LogManager.getLogger(Message.class);
    private static Pattern blockElementCheck = Pattern.compile("[\\[|\\<](?!color|action|link|css|button|input|label|select|textarea|abbr|strong|img|a[\\s\\]]|span[\\s\\]]|b[\\s\\]]|i[\\s\\]]|br[\\s\\]/])[^/]*?/?[\\]|\\>]");
    private String messageText;
    private String wrapperTag;
    private boolean renderWrapperTag = true;
    private List<Component> inlineComponents;
    private List<Component> messageComponentStructure;
    private boolean parseComponents = true;
    private boolean richMessage;
    private boolean containsBlockElements;

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (this.messageText != null && this.messageText.contains("[") && this.messageText.contains("]") && (this.messageComponentStructure == null || this.messageComponentStructure.isEmpty())) {
            this.richMessage = true;
            Matcher matcher = blockElementCheck.matcher(this.messageText);
            this.containsBlockElements = matcher.find();
            if (StringUtils.isBlank((String)this.wrapperTag) && this.containsBlockElements) {
                this.wrapperTag = "div";
            }
            try {
                this.messageComponentStructure = MessageStructureUtils.parseMessage(this.getId(), this.getMessageText(), this.getInlineComponents(), ViewLifecycle.getView(), this.parseComponents);
            }
            catch (RuntimeException e) {
                LOG.info("unable to parse message " + this.getMessageText() + " for id " + this.getId(), (Throwable)e);
            }
        } else if (this.messageText != null && this.messageText.contains("<") && this.messageText.contains(">")) {
            Matcher matcher = blockElementCheck.matcher(this.messageText);
            this.containsBlockElements = matcher.find();
            if (StringUtils.isBlank((String)this.wrapperTag) && this.containsBlockElements) {
                this.wrapperTag = "div";
            }
        }
        if (StringUtils.isBlank((String)this.wrapperTag)) {
            this.wrapperTag = "p";
        }
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        if (this.messageComponentStructure != null && !this.messageComponentStructure.isEmpty()) {
            this.addDataAttribute("parent", parent.getId());
        }
    }

    @Override
    public boolean isRender() {
        boolean render = super.isRender();
        if (render) {
            render = this.getPropertyExpressions().containsKey("messageText") || StringUtils.isNotBlank((String)this.messageText) && !StringUtils.equals((String)this.messageText, (String)"&nbsp;");
        }
        return render;
    }

    @BeanTagAttribute
    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    @BeanTagAttribute
    public String getWrapperTag() {
        return this.wrapperTag;
    }

    public void setWrapperTag(String wrapperTag) {
        this.wrapperTag = wrapperTag;
    }

    @BeanTagAttribute
    public boolean isRenderWrapperTag() {
        return this.renderWrapperTag && this.wrapperTag != null;
    }

    public void setRenderWrapperTag(boolean renderWrapperTag) {
        this.renderWrapperTag = renderWrapperTag;
    }

    public List<Component> getMessageComponentStructure() {
        return this.messageComponentStructure;
    }

    public void setMessageComponentStructure(List<Component> messageComponentStructure) {
        this.messageComponentStructure = messageComponentStructure;
    }

    @BeanTagAttribute
    @ViewLifecycleRestriction(exclude={"APPLY_MODEL", "FINALIZE"})
    public List<Component> getInlineComponents() {
        return this.inlineComponents;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        this.inlineComponents = inlineComponents;
    }

    @BeanTagAttribute
    public boolean isParseComponents() {
        return this.parseComponents;
    }

    public void setParseComponents(boolean parseComponents) {
        this.parseComponents = parseComponents;
    }

    public boolean isRichMessage() {
        return this.richMessage;
    }

    public boolean isContainsBlockElements() {
        return this.containsBlockElements;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        if (this.getMessageText() == null && Validator.checkExpressions(this, "messageText")) {
            String[] currentValues = new String[]{"messageText  =" + this.getMessageText()};
            tracer.createWarning("MessageText should be set", currentValues);
        }
        super.completeValidation(tracer.getCopy());
    }
}

